function [finaldata]=align_and_normalize(mzaxis,processed,P1low,P1high,P2low,P2high,type);
%This program will align and normalize your data prior to PCA processing.
%You will choose two peaks to align the data to and decide whether you wish
%to normalize by height, area, or neither.  You need to give a range of m/z
%values for a particular peak as it appears in all the spectra (e.g. 12500 
%to 12750).  During the aligning, the algorithm will first determine the
%m/z value that the user-defined peaks occur at, calculate the median m/z
%for all peaks, and align all spectra to this median m/z.

%INPUTS
%mzaxis - this is your m/z axis of the data at the appropriate step in the
%process.  Here, the m/z axis may or may not be downsampled.

%processed - this is a matrix of your smoothed, baseline subtracted data.
%Each row is a mz spectrum and each column is a specific mass to charge
%ratio.

%P1low - lower limit of the range over which you set the first aligning
%peak to.  Units are in m/z.

%P1high - upper limit of the range over which you set the first aligning
%peak to.  Units are in m/z.

%P2low - lower limit of the range over which you set the second aligning
%peak to.  Units are in m/z.

%P2high - upper limit of the range over which you set the second aligning
%peak to.  Units are in m/z.

%type - sets the type of normalization you wish to use.  replace type with
%the following to normalize by various things
%'height' - will normalize all spectra such that the maximum in each
%spectrum is 1 (relative abundance).
%'area' - will normalize all spectra such that they all have the same total
%area.
%'none' - will not normalize spectra.  


%OUTPUTS
%finaldata - this is a matrix of your aligned normalized data.  each row
%represents a specific pixel and each column represents a specific mass to
%charge ratio.




%These commands find which points along the array contain your m/z values
%of interest.

[aa,bb]=size(processed);

IP11low=find(mzaxis>P1low);
IP11low=min(IP11low);
IP1high=find(mzaxis<P1high);
IP1high=max(IP1high);
IP21low=find(mzaxis>P2low);
IP21low=min(IP21low);
IP2high=find(mzaxis<P2high);
IP2high=max(IP2high);

%these commands actually perform the aligning.
for x=1:aa
    [y(x),I3(x)]=max(processed(x,IP11low:IP1high));
    I3(x)=I3(x)+IP11low;
    [y(x),I4(x)]=max(processed(x,IP21low:IP2high));
    I4(x)=I4(x)+IP21low;
end

I1=median(I3);
I2=median(I4);

for x=1:aa
[shifted(x,:)] = alignspectra(I1,I2,I3(x),I4(x),processed(x,:));
end

TIC=sum(shifted');
%the following command lines will normalize your data however you see fit.
if (strcmp('height',type)==1)
    for x=1:aa
        finaldata(x,:)=shifted(x,:)/max(shifted(x,:));
    end
elseif (strcmp('area',type)==1)
    for x=1:aa
        finaldata(x,:)=shifted(x,:)/sum(shifted(x,:));
    end
elseif (strcmp('none',type)==1)
    finaldata=shifted;
end

%this generates a nice pretty graph
figure
plot(mzaxis,finaldata')
xlabel('Mass to Charge Ratio (m/z)')
ylabel('Intensity')
set(gca,'FontSize',16)
set(gcf, 'color', 'white');
xlabel('Mass to Charge Ratio (m/z)','FontSize',16)
ylabel('Intensity','FontSize',16)
